const GroupServiceUtil = Packages.com.liferay.portal.service.GroupServiceUtil();
const PortletBeanLocatorUtil = Packages.com.liferay.portal.kernel.bean.PortletBeanLocatorUtil();
const UserLocalServiceUtil = Packages.com.liferay.portal.service.UserLocalServiceUtil();
const LayoutServiceUtil = Packages.com.liferay.portal.service.LayoutServiceUtil();
const LayoutLocalServiceUtil = Packages.com.liferay.portal.service.LayoutLocalServiceUtil();
const PortletPreferencesLocalServiceUtil = com.liferay.portal.service.PortletPreferencesLocalServiceUtil();
const PortalUtil = Packages.com.liferay.portal.util.PortalUtil();
const GroupConstants = Packages.com.liferay.portal.model.GroupConstants();
const LayoutConstants = Packages.com.liferay.portal.model.LayoutConstants();
const PortletKeys = Packages.com.liferay.portal.util.PortletKeys();
const DLAppServiceUtil = Packages.com.liferay.portlet.documentlibrary.service.DLAppServiceUtil();
const DLFileEntryLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil();
const DLFolderLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil();
const AssetCategoryLocalServiceUtil = com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil();
const AssetEntryLocalServiceUtil = com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil();
const DLFileEntryMetadataLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil();
const ResourcePermissionLocalServiceUtil = com.liferay.portal.service.ResourcePermissionLocalServiceUtil();
const RoleLocalServiceUtil = com.liferay.portal.service.RoleLocalServiceUtil();

const WebContentService = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'webContentService' );
const PageLeadAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'pageLeadAdapter' );
const ContentBodyAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'contentBodyAdapter' );
const PageSectionAdapter = PortletBeanLocatorUtil.locate( 'em-point-content-viewer', 'pageSectionAdapter' );

const defaultCompanyId = PortalUtil.getDefaultCompanyId();
const adminUser = UserLocalServiceUtil.getUserByScreenName(defaultCompanyId, "padmin");
const serviceContext = Packages.com.liferay.portal.service.ServiceContext();
const defaultParentLayoutId = LayoutConstants.DEFAULT_PARENT_LAYOUT_ID;
const defaultLayoutTemplate = '1_column_12';
const adtPortletSuffix = '_WAR_empointadtviewer';
const contentPortletSuffix = '_WAR_empointcontentviewer';

var roles = [
"editors_central_region",
"editors_ceo_executive",
"editors_communications",
"editors_work_health_safety",
"editors_taskforces",
"editors_state_training",
"editors_state_operations",
"editors_south_west_region",
"editors_records",
"reception_editors",
"editors_projects",
"editors_north_west_region",
"editors_north_east_region",
"editors_mid_west_region",
"editors_ict",
"editors_human_resources",
"editors_grants_funding",
"editors_finance",
"editors_emergency_management",
"editors_media_community_information",
"editors_east_region",
"editors_assets_infrastructure",
"irs_training_editors"
];

for (var r in roles) {
  var roleName = roles[r];

  var role = RoleLocalServiceUtil.getRole(defaultCompanyId, roleName);
  var perms = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions(role.getRoleId()).toArray();
  
  out.println(role);

  for (var p in perms) {
    out.println(perms[p]);
  }
  out.println("  ");
}